/*
 * Decompiled with CFR 0.152.
 */
package mod.beethoven92.betterendforge.common.recipes;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import mod.beethoven92.betterendforge.common.recipes.SpecialInfusionRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;

public class ModRecipeManager {
    public static final Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> RECIPES = Maps.newHashMap();

    public static void addRecipe(IRecipeType<?> type, IRecipe<?> recipe) {
        HashMap list = RECIPES.get(type);
        if (list == null) {
            list = Maps.newHashMap();
            RECIPES.put(type, list);
        }
        list.put(recipe.func_199560_c(), recipe);
    }

    public static Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> getMap(Map<IRecipeType<?>, Map<ResourceLocation, IRecipe<?>>> recipes) {
        HashMap result = Maps.newHashMap();
        for (IRecipeType<?> type : recipes.keySet()) {
            HashMap typeList = Maps.newHashMap();
            typeList.putAll(recipes.get(type));
            result.put(type, typeList);
        }
        for (IRecipeType<?> type : RECIPES.keySet()) {
            Map<ResourceLocation, IRecipe<?>> list = RECIPES.get(type);
            if (list == null) continue;
            Map typeList = (Map)result.get(type);
            if (typeList == null) {
                typeList = Maps.newHashMap();
                result.put(type, typeList);
            }
            for (Map.Entry<ResourceLocation, IRecipe<?>> entry : list.entrySet()) {
                ResourceLocation id = entry.getKey();
                if (typeList.containsKey(id)) continue;
                typeList.put(id, entry.getValue());
            }
        }
        return result;
    }

    public static void registerSpecialRecipes() {
        SpecialInfusionRecipes.createRecipes();
    }
}

